(ns crux.jon
  (:require [datomic.api :as d]))

(def schema [#:db{:ident :fix/name
                  :cardinality :db.cardinality/one
                  :valueType :db.type/string
                  :db/fulltext true}])

(defn with-datomic [f]
  (let [uri (str "datomic:mem://bench")]
    (try
        (d/delete-database uri)
        (d/create-database uri)
        (let [conn (d/connect uri)]
          (try
            @(d/transact conn schema)
            (f conn)
            (finally
              (d/release conn))))
        (finally
          (d/delete-database uri)
          (d/shutdown false)))))

(with-datomic

;; 1 ([Ivan Bob Bob Bob 1.0]) ;; lets see if we can match this
;; 1.1 ([Ivan Bob 1.0] [Ivan Bob Bob Bob 0.7999999839593196])
;; 1.2 ([Ivan 1.0] [Ivan Bob 0.625] [Ivan Bob Bob Bob 0.5])
;; 2 ([Ivan 1.0] [Ivan Bob 0.625] [Ivan Bob Bob Bob 0.5])
  ;; 3 ([Ivan Bob 0.625] [Ivan Bob Bob Bob 0.5])

;  "(e.g, proximity of terms, complete matches vs stemmed matches, etc"

  (fn [conn]
    (let [scores-for-jane (fn []
                            (sort (vec (d/q '[:find ?val ?score :in $ ?name
                                              :where [(fulltext $ :fix/name ?name)
                                                      [[?ent ?val ?tx ?score]]]]
                                            (d/db conn) "Ivan"))))]

      @(d/transact conn [{:db/id (d/tempid :db.part/user)
                          :fix/name "Ivan Bob Bob Bob"}])

      @(d/transact conn [{:db/id (d/tempid :db.part/user)
                          :fix/name "Somethinge sle"}])

      ;; normalise the scores & rounded

      (println "1" (scores-for-jane))

      @(d/transact conn [{:db/id (d/tempid :db.part/user)
                          :fix/name "Ivan Bob"}])

      (println "1.1" (scores-for-jane))

      @(d/transact conn [{:db/id (d/tempid :db.part/user)
                          :fix/name "Ivan"}])

      (println "1.2" (scores-for-jane))

      ;; This shows the total number of docs with that field isn't taken into account

      @(d/transact conn [{:db/id (d/tempid :db.part/user)
                          :fix/name "NO MATCH"}])

      (println "2" (scores-for-jane))

      (let [[?e] (first (d/q '[:find ?e :in $
                               :where [?e :fix/name "Ivan"]]
                             (d/db conn)))]
        @(d/transact conn [[:db/retract ?e :fix/name "Ivan"]]))

      (println "3" (scores-for-jane)))))

;; Datomic are using Classic, scores are impacted by frequency

;; Have the exact same time for both, copy the one below

;; 1) Index :name, "First Jane After"
;; 2) Search :name "Jane" -> ([First Jane After 1.0])
;; 3) Index :name, "Jane"
;; 4) Search :name "Jane" -> ([First Jane After 0.5] [Jane 1.0])
;; 5) Retract :name, "Jane"
;; 6) Search :name "Jane" -> ([First Jane After 0.5])

;; Purely about boosting

(with-datomic
  (fn [conn]
    (let [scores-for-jane (fn []
                            (sort (vec (d/q '[:find ?val ?score :in $ ?name
                                              :where [(fulltext $ :fix/name ?name)
                                                      [[?ent ?val ?tx ?score]]]]
                                            (d/db conn) "Jane"))))]

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "First Jane After"}])

      (println "1" (scores-for-jane))

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "Jane"}])

      (println "2" (scores-for-jane))

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "Jane 2"}])

      (println "3" (scores-for-jane))

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "Second Jane After"}])

      (println "4" (scores-for-jane))

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "Jane "}])


      #_(doseq [n (range 10)]
        (d/transact conn [{:db/id (d/tempid :db.part/user)
                           :fix/name (str "Jane asd " n)}]))

      (println "5" (scores-for-jane)))))


(with-datomic
  (fn [conn]
    (let [scores-for-jane (fn []
                            (sort (vec (d/q '[:find ?val ?score :in $ ?name
                                              :where [(fulltext $ :fix/name ?name)
                                                      [[?ent ?val ?tx ?score]]]]
                                            (d/db conn) "Jane"))))]

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "First Jane After"}])

      (println "1" (scores-for-jane))

      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "Jane"}])

      (println "2" (scores-for-jane))

      (let [[?e] (first (d/q '[:find ?e :in $
                               :where [?e :fix/name "Jane"]]
                             (d/db conn)))]
        (d/transact conn [[:db/retract ?e :fix/name "Jane"]]))

      (println "3" (scores-for-jane)))))

(with-datomic
  (fn [conn]
    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "ASD"}])
    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "Jane"}])
    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "2 Jane foo"}])

    (println (sort (vec (d/q '[:find ?val ?score :in $ ?name
                               :where [(fulltext $ :fix/name ?name)
                                       [[?ent ?val ?tx ?score]]]]
                             (d/db conn) "Jane"))))

    (doseq [i (range 100)]
      (d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name (str i " Jane Foo")}]))

    (doseq [[?e ?v] (d/q '[:find ?e ?v :in $
                           :where [?e :fix/name ?v]]
                         (d/db conn))]
      (d/transact conn [[:db/retract ?e :fix/name ?v]]))

    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "2 Jane foo"}])

    (println (sort (vec (d/q '[:find ?val ?score :in $ ?name
                               :where [(fulltext $ :fix/name ?name)
                                       [[?ent ?val ?tx ?score]]]]
                             (d/db conn) "Jane"))))))
(with-datomic
  (fn [conn]
    ;; This impacts the score:
    #_(doseq [n (range 100)]
        (d/transact conn [{:db/id (d/tempid :db.part/user)
                           :fix/name (str "CONTROL" n)}]))

    #_(d/transact conn [{:db/id (d/tempid :db.part/user)
                         :fix/name "Jane"}])

    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "Foo Jane"}])


    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "Foo Jane"}])

    (println (d/q '[:find ?val ?score :in $ ?name
                    :where [(fulltext $ :fix/name ?name)
                            [[?ent ?val ?tx ?score]]]]
                  (d/db conn) "Jane"))

    #_(dotimes [n 100]
        (d/transact conn [{:db/id (d/tempid :db.part/user)
                           :fix/name "Foo"}]))

    #_(let [eid (ffirst (d/q '[:find ?ent :in $ ?name
                               :where [(fulltext $ :fix/name ?name)
                                       [[?ent ?val ?tx ?score]]]]
                             (d/db conn) "CONTROL"))]
        (d/transact conn [[:db/retract eid :fix/name "CONTROL"]]))

    (d/q '[:find ?val ?score :in $ ?name
           :where [(fulltext $ :fix/name ?name)
                   [[?ent ?val ?tx ?score]]]]
         (d/db conn) "Foo")

    (d/q '[:find ?val ?score :in $ ?name
           :where [(fulltext $ nil ?name)
                   [[?ent ?val ?tx ?score]]]]
         (d/db conn) "Foo")))

;; in Datomic, if you keep the same db around, but index a few more full text values, do the scores fluctuat



(with-datomic
  (fn [conn]
    (d/transact conn [{:db/id (d/tempid :db.part/user)
                       :fix/name "Ivan Bob"}])

    (println (sort (vec (d/q '[:find ?val ?score :in $ ?name
                               :where [(fulltext $ :fix/name ?name)
                                       [[?ent ?val ?tx ?score]]]]
                             (d/db conn) "Ivan")))))) ;; .70
