(ns juxt.clip.joke-integrant
  (:require
    [juxt.clip.core :as clip]
    [juxt.clip.impl.core :as impl]
    [clojure.walk :as walk]
    [integrant.core :as ig]))

(defn integrant-method-f
  [multi-fn]
  (fn [[k arg]]
    (fn [rf acc]
      (rf acc k
          (multi-fn
            k
            (walk/postwalk
              (fn [x]
                (if (impl/ref? x)
                  (get acc (second x))
                  x))
              (if (contains? acc k)
                (get acc k)
                arg)))))))

(def chains
  {:start
   (fn [component-chain]
     (map (integrant-method-f ig/init-key) component-chain))
   :stop
   (fn [component-chain]
     (map (integrant-method-f ig/halt-key!) component-chain))})

(comment
  (do
    (defmethod ig/init-key ::foo
      [_ x]
      [:start x])
    (defmethod ig/halt-key! ::foo
      [_ x]
      [:stopped (second x)]))

  (let [system-config {:components {::foo 10
                                    [::foo ::bar] [:reference-to (clip/ref ::foo)]}
                       :chains chains}]
    (clip/stop
      system-config
      (clip/start system-config)))
  )
