(ns utilities.templates
  (:require [digest]
            [utilities.settings :as settings]
            [utilities.files :as files]
            [clojure.java.io :as io]))


(defn create-hash-copy
  "Hashes given file in given directory and returns new hashed name"
  [f res-dir]
  (if-not settings/in-production?
    (str "/static/" f)
    (let [res-dir       (io/resource res-dir)
          [name ext]    (files/name-ext f)
          content       (slurp (io/file res-dir f))
          hash          (digest/md5 content)
          new-name      (str name "." (subs hash 0 10) "." ext)
          d-path        (io/file res-dir "hashes" new-name)]
      (io/make-parents d-path)
      (spit d-path content)
      (str "static/hashes/" new-name))))


(defn hash-links
  "Hashes given files and returns embed html"
  ([coll-f] (hash-links coll-f "public"))
  ([coll-f res-dir]
   (for [f coll-f]
     (-> f
         (create-hash-copy res-dir)))))
