(ns {{ name }}.pages
  (:require [stencil.core :as m]
            [hiccup.core :refer [html]]
            [utilities.templates :as t]
            [utilities.forms.core :as f]))


(def ^:private normal-css
  (t/hash-links ["css/normalize.css" "css/style.css"]))

(defn render-child-content
  [template context]
  (m/render-file (str "html/content/" template) context))


(defn render-in-base
  [request stylesheets javascripts template context]
  (m/render-file "html/base.mustache"
                 {:stylesheets  stylesheets
                  :title        (:title context)
                  :flash        (:flash request)
                  :content      (render-child-content template context)
                  :javascripts  javascripts}))


(defn render
  [request template context]
  (render-in-base request normal-css nil template context))


(defn render-confirm-delete
  "Renders form to confirm delete action"
  [request name url]
  (render request "confirm-delete.mustache"
          {:title      ("Delete " name)
           :url        url
           :csrf-token (f/csrf-token)}))


(defn page-not-found
  "Render Page not found"
  [request]
  (let [uri (:uri request)]
    (render request "route-404.mustache"
            {:title "Page not found"})))
