(ns utilities.logging
  (:require [taoensso.timbre.appenders.postal :as postal-a]
            [taoensso.timbre.appenders.core :as core-appender]
            [utilities.settings :as settings]
            [postal.core :as postal]))


; Postal appender has good defaults
; https://github.com/ptaoussanis/timbre/blob/master/src/taoensso/timbre/appenders/postal.clj
(defn mailer
  "Returns postal appender with config"
  []
  (let [config (with-meta {:from settings/email-default-from
                           :to settings/email-admins}
                          settings/email-spec)]
    (postal-a/postal-appender config)))


(defn send-test-mail
  "Sends a test email to admins"
  []
  (let [msg {:from    settings/email-default-from
             :to      settings/email-admins
             :subject "Testing Mails"
             :body    "Woohoo!!!"}
        msg (with-meta msg settings/email-spec)]
    (println
      (postal/send-message msg))))
