(ns utilities.factories
  (:require [utilities.db :as db]))


(def i (atom 1000))

(defn unique-sequence
  "Returns a unique number in sequence"
  []
  (swap! i inc))


(defn sample
  "generates sample record for given table"
  [table options]
  (db/first! (db/query table options)))


(defmacro factory
  "Creates a factory function"
  ;([table defaults] (factory table defaults identity))

  ([table defaults modifier-fn]
   (fn [values]
      (let [values   (merge ~defaults values)
            values   (modifier-fn values)]
        (db/create table values)))))


(comment
   (macroexpand '(factory "books" {:name "foo"} identity))
  )
