(ns utilities.exceptions
  (:require [ring.util.response :as res]
            [taoensso.timbre :as timbre]))

(defn raise
  "Throws Exception with given message"
  [cause msg]
  (throw (ex-info msg {cause true})))


(defn cause?
  "Returns true if the cause of error matches the given cause"
  [^Exception e cause]
  (get (ex-data e) cause))


(defn message
  "Returns message from given exception"
  [^Exception e]
  (.getMessage e))


(defn exceptions-middleware
  "Provides middleware to return page not found if cause is ::page-not-found"
  [handler]
  (fn [request]
    (try
      (handler request)
      (catch Throwable e
        (let [err-data (ex-data e)]
          (cond
            (contains? err-data ::page-not-found) (res/not-found (message e))
            (contains? err-data ::force-redirect) (res/redirect (message e))
            :else (do (timbre/error e request)
                      (throw e))))))))
