(ns utilities.exceptions
  (:require [ring.util.response :as res]))

(defn raise
  "Throws Exception with given message"
  [cause msg]
  (throw (ex-info msg {cause true})))


(defn cause?
  "Returns true if the cause of error matches the given cause"
  [^Exception e cause]
  (get (ex-data e) cause))


(defn message
  "Returns message from given exception"
  [^Exception e]
  (.getMessage e))


(defn exceptions-middleware
  "Provides middleware to return page not found if cause is ::page-not-found"
  [handler]
  (fn [request]
    (try
      (handler request)
      (catch Exception e
        (cond
          (cause? e ::page-not-found)      (res/not-found (message e))
          (cause? e ::suspicious-activity) (res/redirect "/")
          (cause? e ::force-redirect)      (res/redirect (message e))
          :else (throw e))))))
