(ns utilities.routing-test
  (:require [utilities.routing :as routes]
            [clojure.test :refer :all]))

(defn- foo [request] "Hello")
(defn- foo-args [request arg] arg)

(def urls [:home "/" foo
           :foo "/foo/::id/bar/" foo-args])

(defn set-test-urls
  [test]
  (with-redefs [routes/_names-p (routes/names-broken-path urls)]
    (test)))

(use-fixtures :each set-test-urls)


(deftest routing-testing
  (testing "reverse urls"
    (is (= (routes/get-url :foo {:id 12, :baz "baz"})
           "/foo/12/bar/"))
    (is (= (routes/get-url :home {:id 12})
           "/")))

  (testing "errors in reversing"
    (is (thrown-with-msg? Exception #":id not provided for :foo url"
                          (routes/get-url :foo {})))))
