(ns {{ name }}.pages
  (:require [hiccup.core :refer [html]]
            [utilities.templates :as t]))


(def ^:private normal-css
  (t/hash-links ["css/normalize.css" "css/style.css"]))

(defn child-content
  [template context]
  (t/fill-in-file (str "html/content/" template) context))


(defn render-in-base
  [request css js template context]
  (t/fill-in-file
    "html/base.html"
    {:title       (:title context)
     :css         css
     :content     (child-content template context)
     :js          js
     :request     request}))


(defn render
  [request template context]
  (render-in-base request normal-css nil template context))


(defn page-not-found
  "Render Page not found"
  [request]
  (let [uri (:uri request)]
    (render request "route-404.html"
            {:title "Page not found"})))
