# Key Concepts and ideas in Jurassic Web


## Templating

- Define own functions for explicit nesting and parsing.
- Providing hashing for static files in production.
- Provide components to be used anywhere.


## Database Querying

- Should not be coupled with any object, entity or library.
- Should allow writing own SQL on fly
- Should be chainable
- Should be safe from SQL injection.


## Routing

- Should be defined with a name, pattern and handling function which takes keyword params in pattern.
- Should have reverse-routing


## Forms

3 Major parts of forms: `validation`, `cleaning`, `rendering`.

- Validation and cleaning should be separate
- Data saving and creation should be separate


## User Sessions

- Database sessions which persist between updates
- CSRF should also persist between updates


## Static Files

- Static files should have a hash which can be set for long-expiry.


## Testing

- Tests should be independent of each other.
    - Databases should clear between tests
- Tests should be fast


## Error Handling

- Email of errors in production


## Profiling

Each response should show processing time
