(ns utilities.responses
  (:require [ring.util.response :as res]))


(defn flash
  "Adds flash msg to response"
  [response type msg]
  (assoc response :flash {:type type, :msg msg}))


(defn redirect-flash
  "Redirect response with "
  [url type msg]
  (let [res (res/redirect url)]
    (flash res type msg)))
