(ns utilities.routing-test
  (:require [utilities.routing :refer :all]
            [clojure.test :refer :all]))

(defn- foo [request] "Hello")
(defn- foo-args [request arg] arg)

(def urls [:home "/" foo
           :foo "/foo/::id/bar/" foo-args])

(defn set-test-urls
  [test]
  (set-urls urls)
  (test)
  (require '[paper-books.urls]))

(use-fixtures :each set-test-urls)


(deftest routing-testing
  (testing "reverse urls"
    (is (= (get-url :foo {:id 12, :baz "baz"})
           "/foo/12/bar/"))
    (is (= (get-url :home {:id 12})
           "/")))

  (testing "errors in reversing"
    (is (thrown-with-msg? Exception #":id not provided for :foo url"
                          (get-url :foo {}))))

  (testing "handlers"
    (let [h (handlers urls)]
      (is (= (count h) 2)))))
