(ns utilities.files-test
  (:require [utilities.files :refer :all]
            [clojure.test :refer :all]))


(deftest test-files
  (testing "file name and extension"
    (is (= (name-ext "foo/bar/baz.pdf") ["baz" "pdf"]))
    (is (= (name-ext "baz.pdf") ["baz" "pdf"]))
    (is (= (name-ext "foo.baz.pdf") ["foo.baz" "pdf"]))
    (is (= (name-ext "/etc/hosts") ["" "hosts"])))

  (testing "join path"
    (is (= (path "/etc/" "/hosts") "/etc/hosts"))
    (is (= (path "public" "www") "public/www"))
    (is (= (path "/foo" "bar") "/foo/bar"))
    (is (= (path "foo/" "/bar") "foo/bar"))))
