(ns utilities.common-components
  (:require [ring.util.codec :as codec]
            [hiccup.core :refer [html]]))


(defn get-params
  "Returns get link after updating current query params with new data"
  [request data]
  (let [params   (:query-params request)
        params   (merge params data)]
    (str "?" (codec/form-encode params))))


(defn- page-link
  ([request n] (page-link request n n))

  ([request n name]
   (when n
     (html [:a {:href (get-params request {:page n})} name]))))


(defn page-numbers
  "Renders page numbers for given page results"
  [request page]
  (let [pages-count   (:pages-count page)
        page-number   (:page-number page)
        prev-page     (if (> page-number 1)
                        (dec page-number))
        start-pages   (if (and prev-page (> prev-page 1))
                        1)
        next-page     (if (> pages-count page-number)
                        (inc page-number))
        end-pages     (if (and next-page (> pages-count next-page))
                        pages-count)]
    (html (page-link request start-pages)
          (page-link request prev-page)
          page-number
          (page-link request next-page)
          (page-link request end-pages))))
