(defproject {{ name }} "0.1.0-SNAPSHOT"
  :description "ADD YOUR {{ name }} description"
  :url "https://www.{{ name }}.com"
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :aliases {"migrate" ["run" "-m" "utilities.migrations/migrate"]
            "migrations" ["run" "-m" "utilities.migrations/validate"]
            "truncate" ["run" "-m" "utilities.testing/truncate"]
            "reset-db" ["run" "-m" "utilities.testing/reset-db"]
            "test" ["run" "-m" "utilities.testing/run"]}
  :dependencies [[org.clojure/clojure "1.10.0"]
                 [compojure "1.6.1"]
                 [ring/ring-defaults "0.3.2"]
                 [hiccup "1.0.5"]
                 ; Authentication
                 [buddy/buddy-hashers "1.3.0"]
                 ; Static files hash
                 [digest "1.4.8"]
                 ; Database
                 [mysql/mysql-connector-java "8.0.15"]
                 [org.clojure/java.jdbc "0.7.8"]
                 ; Connection pooling
                 [com.zaxxer/HikariCP "3.3.1"]
                 ; Liquibase for migrations
                 [org.liquibase/liquibase-core "3.6.3"]
                 ; Loggging dependencies
                 [org.clojure/tools.logging "0.4.1"]
                 [org.slf4j/slf4j-simple "1.7.26"]
                 ; testing
                 [org.clojure/tools.namespace "0.2.11"]
                 [org.jsoup/jsoup "1.11.3"]
                 ]
  :plugins [[lein-ring "0.12.5"]]
  :ring {:handler {{ name }}.handler/app}
  :profiles {:dev {:dependencies [[javax.servlet/servlet-api "2.5"]
                                  [ring/ring-mock "0.3.2"]
                                  [peridot "0.5.1"]]}})
