(ns utilities.templates-test
  (:require [clojure.test :refer :all]
            [utilities.templates :refer :all]))


(deftest test-break-text
  (testing "breaking of text"
    (let [text (str "Foo\n"
                    "::foo?"
                    "\n\n"
                    "Bar")
          context {:foo "Hello"}]
      (is (= (break-text text)
             (list "Foo\n" :foo "?\n\nBar")))
      (is (= (fill-in-text text context)
             "Foo\nHello?\n\nBar")))))


(deftest test-fill-in-text
  (testing "fill-in-text"
    (is (= (fill-in-text
             "I am a ::object. I have ::thing."
             {:object "teapot", :thing "2 hands"})
           "I am a teapot. I have 2 hands.")))

  (testing "fill-in-text empty"
    (is (= (fill-in-text
             "I am a teapot."
             {})
           "I am a teapot.")))

  (testing "fill-in-text with collections"
    (is (= (fill-in-text "I am ::things"
                         {:things [1 2 3]})
           "I am 1\n2\n3"))))
