# Introduction to Jurassic-web


## Advantages of Clojure

- **Clojure is based on LISP:** It has a single common syntax where everything is a `list`. Lists are `processed`. The tree structure of lists allow Clojure to provide the powerful macro functionality.

- **Functional Programming:** Clojure advocate use of pure functions instead of classes. Pure functions take "data" as argument and returns data back. Pure functions return same data everytime for given arguments. Thus they can be easily debugged and maintained as a single piece of code.

- **Immutability:** Clojure data types are immutable. Thus the functions don't modify the arguments passed originally to it and instead read the new data back.
 
- **JAVA Ecosystem:** Clojure is built upon the java virtual machine and thus provide the whole java ecosystem to be used.


## Development Guides

[**Project Structure**](structuring.md): Which files should go where. How to organize code.

[**Templating**](templating.md): How we render HTML pages using Clojure.

[**Forms**](forms.md): How to handle form validations and rendering.

[**Routing**](routing.md): How to define website urls.

[**Querying**](querying.md): How to run database queries.

[**Migrations**](migrations.md): How to create and handle database migrations.

[**Testing**](testing.md): How to test requests and responses.