(ns leiningen.new.jurassic-web
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]
            [clojure.java.io :as io]
            [manager :as manager]
            [utilities.files :as f]
            [clojure.edn :as edn]))


(def render (renderer "jurassic-web"))


(defn- copy-same
  "Copies file from resource as it is to new project"
  [f]
  [f (render f)])


(defn- managed-sources
  []
  (let [files (edn/read-string (slurp manager/resource-edn))]
    (for [f files]
      (copy-same f))))


(defn jurassic-web
  "Create the structure for new project"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' jurassic-web project.")
    (->files data
             (conj (managed-sources)
                   [".gitignore"  (render "gitignore")]
                   [".editorconfig"  (render "editorconfig")]

                   ["resources/db/changelog.xml" (render "db/changelog.xml")]

                   ["resources/public/css/normalize.css" (render "css/normalize.css")]
                   ["resources/public/css/style.css" (render "css/style.css")]

                   ["resources/html/base.html" (render "html/base.html")]
                   ["resources/html/content/hello.html" (render "html/content/hello.html")]

                   ["resources/simplelogger.properties" (render "simplelogger.properties")]

                   ; Files requiring parsing
                   ["project.clj" (render "project.clj" data)]
                   ["README.md"  (render "README.md" data)]
                   ["src/{{sanitized}}/pages.clj" (render "project/pages.clj" data)]
                   ["src/{{sanitized}}/urls.clj" (render "project/urls.clj" data)]
                   ["src/{{sanitized}}/handler.clj" (render "project/handler.clj" data)]))))
