(ns utilities.settings)


(def in-development? (= (System/getenv "FRYPAN_DEVELOPMENT") "yes"))
(def in-testing? (= (System/getenv "FRYPAN_TESTING") "yes"))


(def mysql-host-port (System/getenv "MYSQL_HOST"))
(def mysql-db (let [name (System/getenv "MYSQL_DATABASE")]
                (if in-testing?
                  (str "test_" name)
                  name)) )
(def mysql-username (System/getenv "MYSQL_USER"))
(def mysql-password (System/getenv "MYSQL_PASSWORD"))


(def db-spec {:classname   "com.mysql.cj.jdbc.Driver"
              :subprotocol "mysql"
              :subname     (str "//" mysql-host-port "/" mysql-db)
              :user        mysql-username
              :password    mysql-password})


(defn memoize-in-prod
  "Memoizes a function in production"
  [f]
  (if in-development?
    f
    (memoize f)))
