(ns {{ name }}.pages
    (:require [hiccup.core :refer [html]]
              [utilities.templates :as t]))


(def simple-page-css (t/css-links ["css/normalize.css"
                                   "css/style.css"]))


(defn simple-page [request title content]
    "Returns narrow width html page with given title and content"
    (let [context {:title title
                   :css simple-page-css
                   :content content
                   :request request}]
        (t/fill-in-page "base.html" context)))


(defn page-not-found
    "Render Page not found"
    [request]
    (let [uri (:uri request)]
        (simple-page request
              "Page Not Found"
              (html [:h1 "Page not found"]
                    [:p "We couldn't find the page you are looking for"]))))
