(ns leiningen.new.jurassic-web
    (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
      [leiningen.core.main :as main]
      [clojure.java.io :as io]))


(def render (renderer "jurassic-web"))


(defn jurassic-web
      "Create the structure for new project"
      [name]
      (let [data {:name name
                  :sanitized (name-to-path name)}]
           (main/info "Generating fresh 'lein new' jurassic-web project.")
           (->files data
                    ["project.clj" (render "project.clj" data)]
                    [".gitignore"  (render "gitignore")]
                    ["README.clj"  (render "README.md")]

                    ["resources/db/changelog.xml" (render "db/changelog.xml")]

                    ["resources/public/css/normalize.css" (render "css/normalize.css")]
                    ["resources/public/css/style.css" (render "css/style.css")]

                    ["resources/html/base.html" (render "html/base.html")]
                    ["resources/html/components/hello.html" (render "html/components/hello.html")]

                    ["resources/simplelogger.properties" (render "simplelogger.properties")]

                    ; utilities
                    ["src/utilities/db.clj" (render "utilities/db.clj")]
                    ["src/utilities/exceptions.clj" (render "utilities/exceptions.clj")]
                    ["src/utilities/files.clj" (render "utilities/files.clj")]
                    ["src/utilities/flash.clj" (render "utilities/flash.clj")]
                    ["src/utilities/migrations.clj" (render "utilities/migrations.clj")]
                    ["src/utilities/routing.clj" (render "utilities/routing.clj")]
                    ["src/utilities/settings.clj" (render "utilities/settings.clj")]
                    ["src/utilities/templates.clj" (render "utilities/templates.clj")]
                    ["src/utilities/testing.clj" (render "utilities/testing.clj")]
                    ["src/utilities/auth/core.clj" (render "utilities/auth/core.clj")]
                    ["src/utilities/auth/middleware.clj" (render "utilities/auth/middleware.clj")]
                    ["src/utilities/forms/core.clj" (render "utilities/forms/core.clj")]
                    ["src/utilities/forms/checks.clj" (render "utilities/forms/checks.clj")]
                    ["src/utilities/forms/field.clj" (render "utilities/forms/field.clj")]


                    ; Files requiring parsing
                    ["src/{{sanitized}}/pages.clj" (render "project/pages.clj" data)]
                    ["src/{{sanitized}}/urls.clj" (render "project/urls.clj" data)]
                    ["src/{{sanitized}}/handler.clj" (render "project/handler.clj" data)])))
