(ns utilities.files
    (:require [clojure.string :as s]
        [clojure.java.io :as io]))


(defn list-files
      "Returns names of files in the given directory"
      [dir-path]
      (let [root  (clojure.java.io/file dir-path)
            root-path (.getPath root)]
           (for [f (file-seq root)
                 :when (.isFile f)]
                (s/replace (.getPath f) root-path ""))))


(defn split-path
      "Splits given file path to a vector"
      [f]
      (s/split f #"/"))


(defn path
      "Joins parts to a file path"
      [& parts]
      (let [p (flatten (map split-path parts))
            s (first p)
            r (remove #(= % "") (rest p))]
           (s/join "/" (concat [s] r))))


(defn name-ext
      "Gives [name ext] for the given file path"
      [f]
      (let [file-name (last (split-path f))
            p (s/split file-name #"\.")
            ext (last p)
            name (s/join "." (butlast p))]
           [name ext]))
