(ns utilities.auth.middleware)


(def AnonymousUser {:authenticated? false})

(defn User
    "Returns logged-in user object available in requests"
    [user-id]
    {:authenticated? true
     :id user-id})


(defn wrap-user [handler]
    "Adds User Record to request map {:user} if user is authenticated
    else adds AnonymousUser if user is unauthenticated"
    (fn [request]
        (if-let [user-id (-> request :session :user-id)]
            (let [user (User user-id)]
                (handler (assoc request :user user)))
            (handler (assoc request :user AnonymousUser)))))
