(ns utilities.testing
    (:require [utilities.db :as db]
              [utilities.settings :as settings]
              [clojure.java.jdbc :as jdbc]))


(defn- run-on-all-tables
    "Runs a command on all tables in database"
    [command]
    (let [tables (jdbc/query settings/db-spec
                             ["SELECT table_name 
                               FROM information_schema.tables
                               WHERE table_schema = ?" settings/mysql-db])
          user-commands (map (fn [{:keys [table_name]}]
                                 (str command " " table_name))
                             tables)
          all-commands (concat ["SET FOREIGN_KEY_CHECKS = 0"]
                               user-commands
                               ["SET FOREIGN_KEY_CHECKS=1"])]
        (println "ALL COMMANDS" all-commands)
        (jdbc/db-do-commands settings/db-spec all-commands)))


(defn rollback
    "Rolls-back everything by running tests inside a transaction"
    [test]
    (jdbc/with-db-transaction [t-conn settings/db-spec]
                              (jdbc/db-set-rollback-only! t-conn)
                              (binding [db/*connection* (delay t-conn)
                                        db/*connection* (delay t-conn)]
                                  (test))))


(defn reset-db
    "Drops all tables in database"
    []
    (run-on-all-tables "DROP TABLE IF EXISTS"))


(defn truncate
    "Truncate all tables"
    ([]
     (truncate (fn [] (println "Truncated all data"))))
    ([test]
     (run-on-all-tables "TRUNCATE TABLE")
     (test)))
