(ns leiningen.new.jurassic-web
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]
            [utilities.files :refer [list-files path]]))


(def render (renderer "jurassic-web"))


(defn dir-files
      [dest-dir src-dir]
      (let [names (list-files
                    (path "resources/leiningen/new/jurassic_web" src-dir))]
           (for [name names]
                [(path dest-dir name) (render (path src-dir name))])))


(defn files-to-copy
      [data]
      (let [f   [[".gitignore"  (render ".gitignore")]
                 ["project.clj" (render "project.clj")]
                 ["README.clj"  (render "README.md")]

                 ["resources/public/base.html"
                  (render "resources/html/base.html")]

                 ["resources/public/components/hello.html"
                  (render "resources/html/components/hello.html")]

                 ["resources/simplelogger.properties"
                  (render "resources/simplelogger.properties")]

                 ; Files requiring parsing
                 ["src/{{sanitized}}/pages.clj"
                  (render "project/pages.clj" data)]
                 ["src/{{sanitized}}/urls.clj"
                  (render "project/urls.clj" data)]
                 ["src/{{sanitized}}/handler.clj"
                  (render "project/handler.clj" data)]]
            f   (into f (dir-files "src/utilities" "utilities"))
            f   (into f (dir-files "resources/public/css" "resources/public/css"))
            f   (into f (dir-files "resources/db" "resources/db"))
            f   (into f (dir-files "doc" "doc"))]
           f))


(defn jurassic-web
  "Create the structure for new project"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' jurassic-web project.")
    (apply ->files data (files-to-copy data))))
