(ns leiningen.new.jurassic-app
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "jurassic-app"))

(defn jurassic-app
  "Template for jurassic app"
  [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' jurassic-app project.")
    (->files data
             ["src/{{sanitized}}/rules.clj" (render "rules.clj" data)]
             ["src/{{sanitized}}/views.clj" (render "views.clj" data)]
             ["src/{{sanitized}}/data.clj" (render "data.clj" data)]
             ["src/{{sanitized}}/components.clj" (render "components.clj" data)])))
