clj-inspector
=============

[![Build Status](https://travis-ci.org/junegunn/clj-inspector.svg?branch=master)](https://travis-ci.org/junegunn/clj-inspector)
[![codecov](https://codecov.io/gh/junegunn/clj-inspector/branch/master/graph/badge.svg)](https://codecov.io/gh/junegunn/clj-inspector)

*inspector* helps debugging Clojure programs.

Installation
------------

Add *inspector* to `user` profile in `~/.lein/profiles.clj`:

```clojure
{:user {:dependencies [[junegunn/inspector "0.1.0"]]
        :injections [(require 'inspector.core)]}}
```

Usage
-----

### inspector.core

```clojure
(require '[inspector.core :refer :all])

;; Print vars in current namespace
(ls)

;; Print vars in the given namespace
(ls *ns*)

;; Print the members of the object
(ls "java object")

;; Print stack trace
(whereami)

;; Capture lexical bindings as a map
(let [foo 1 bar 2] (env))
```

### Inspection macros and reader tags

`#i/?` prints debugging information for the following form to `*out*`.

```clojure
(let [foo 1
      bar 2]
  #i/? (+ foo #i/? (* bar bar)))

;; ┌ (+ foo (* bar bar))
;; │  at user$eval40206.invokeStatic (form-init3537188508571310180.clj:1)
;; │ ┌ (* bar bar)
;; │ │  at user$eval40206$fn__40209.invoke (form-init3537188508571310180.clj:3)
;; │ │  result:  4
;; │ │  elapsed: 5 us
;; │ ├  locals:
;; │ │    bar: 2
;; │ │    foo: 1
;; │ └
;; │  result:  5
;; │  elapsed: 5120 us
;; ├  locals:
;; │    bar: 2
;; │    foo: 1
;; └
```

Alternatively, you can use `#i/!` to print the message to `System/out`. It's
useful when you're connected to an nREPL server running on a terminal window
and you want the messages to be printed on that window.

For multiple forms, use `inspector.core/doinspect` and
`inspector.core/doinspect!` macros which correspond to `#i/?` and `#i/!`
respectively.

```clojure
(doinspect
  (rand-int 100)
  (rand-int 100))

;; ┌ (rand-int 100)
;; │  at user$eval54112.invokeStatic (:1)
;; │  result:  21
;; │  elapsed: 18 us
;; └
;; ┌ (rand-int 100)
;; │  at user$eval54135.invokeStatic (:1)
;; │  result:  49
;; │  elapsed: 17 us
```

Inspiration
-----------

*inspector* was heavily inspired by [spyscope][spyscope].

[spyscope]: https://github.com/dgrnbrg/spyscope

License
-------

The MIT License (MIT)

Copyright (c) 2017 Junegunn Choi
