# hbase-clj

HBase in idiomatic Clojure.

## Installation

```clojure
[hbase-clj "0.1.0-SNAPSHOT"]
```

hbase-clj is a work in progress. The API is not guaranteed to be stable.

## Usage

See [walkthrough.clj](examples/walkthrough.clj).

## REPL Usage

By default, hbase-clj is a thin wrapper around the HBase Java client API. But
activating `repl` profile will bring in a bunch of libraries and helper
functions to turn it into a standalone REPL for accessing HBase.

```sh
# Start nREPL
make repl

# Build uberjar
make uberjar
```

### Functions

Type in `(help)` to see the list of added functions

### Included libraries

- Clojure
    - [clojure.data.json](https://github.com/clojure/data.json)
    - [clojure.java.jdbc](https://github.com/clojure/java.jdbc)
    - [clojure.tools.nrepl](https://github.com/clojure/tools.nrepl)
    - [clojure.tools.trace](https://github.com/clojure/tools.trace)
    - [clojure.core.async](https://github.com/clojure/core.async)
    - [HTTP Kit](https://github.com/http-kit/http-kit)
    - [Reply](https://github.com/trptcolin/reply/)
    - [Pomegranate](https://github.com/cemerick/pomegranate)
    - [junegunn/grouper](https://github.com/junegunn/grouper)
- Java
    - [Asynchbase](https://github.com/opentsdb/asynchbase)
    - [HdrHistogram](https://github.com/HdrHistogram/HdrHistogram)

## License

MIT
