# ring.middleware.cors

simple middleware for easy cross-origin resource sharing

## rationale

the promise of black-box abstraction, realized here in the form of a ring handler, makes it unnecessesary for the consumer to be concerned with the intricacies of http.  specific to the case of cross-origin requests, there's little reason to expose the many options and behaviours enumerated by the w3c to an application developed with an awareness of cors from the outset; the vast majority of these settings exist to provide an upgrade path to servers that predate the specification.  this library consequently abstracts away these details, assuming that it will be used with a modern, cors-aware service in order to expose the most straightforward api possible.

## installation

[![latest version][1]][2]

## application

simply pass the wrapper some regular expressions

```clojure
(require '[ring.middleware.cors :refer [wrap-cors]])

;; accept everything
(wrap-cors routes #".*")
(wrap-cors routes identity)

;; accept some things
(wrap-cors routes #".*localhost.*" #".*mydomain.org")
(wrap-cors routes #(= (:allowed-origin db) %))

;; accept one thing
(wrap-cors routes #"http://myapp.mydomain.org")

;; accept nothing
(wrap-cors routes)
```

## considerations

complexities such as the cors preflight [have little to do with security.  rather, they exist to ensure consistency on behalf of][3] servers that predate the [cors specification][4] (and by example, never expected a cross-domain DELETE request).  the preflight allows these legacy servers to selectively expose individual methods and headers to cross-origin requests.  since this scenario doesn't apply to a newly-developed service, this wrapper permissively authorizes the user agent from an authorized origin to use all requested methods, headers, and cookies.  

this middleware instructs the browser to cache the preflight for 24 hours based on a w3c discussion of the subject.  mozilla has adapted 24 hours as the max cache time for the preflight, while webkit will max out in just five minutes.  the cache can be cleared manually from the browser if necessary during development.  in chrome, this is achieved by setting the "disable cache while devtools is open" flag in the development tools settings panel.

## license

copyright (c) jumblerg. all rights reserved.

distributed with clojure under the eclipse public license

[1]: https://clojars.org/jumblerg/ring.middleware.cors/latest-version.svg?bustcache=1.0.0
[2]: https://clojars.org/jumblerg/ring.middleware.cors
[3]: http://stackoverflow.com/questions/15381105/cors-what-is-the-motivation-behind-introducing-preflight-requests
[4]: http://www.w3.org/TR/cors/