goog.provide('re_frame.trace');
re_frame.trace.id = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
re_frame.trace._STAR_current_trace_STAR_ = null;
re_frame.trace.reset_tracing_BANG_ = (function re_frame$trace$reset_tracing_BANG_(){
return cljs.core.reset_BANG_(re_frame.trace.id,(0));
});
/**
 * @define {boolean}
 */
re_frame.trace.trace_enabled_QMARK_ = goog.define("re_frame.trace.trace_enabled_QMARK_",false);
/**
 * See https://groups.google.com/d/msg/clojurescript/jk43kmYiMhA/IHglVr_TPdgJ for more details
 */
re_frame.trace.is_trace_enabled_QMARK_ = (function re_frame$trace$is_trace_enabled_QMARK_(){
return re_frame.trace.trace_enabled_QMARK_;
});
re_frame.trace.trace_cbs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.traces !== 'undefined')){
} else {
re_frame.trace.traces = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
}
if((typeof re_frame !== 'undefined') && (typeof re_frame.trace !== 'undefined') && (typeof re_frame.trace.next_delivery !== 'undefined')){
} else {
re_frame.trace.next_delivery = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
}
/**
 * Registers a tracing callback function which will receive a collection of one or more traces.
 *   Will replace an existing callback function if it shares the same key.
 */
re_frame.trace.register_trace_cb = (function re_frame$trace$register_trace_cb(key,f){
if(re_frame.trace.trace_enabled_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(re_frame.trace.trace_cbs,cljs.core.assoc,key,f);
} else {
return re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"warn","warn",-436710552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Tracing is not enabled. Please set {\"re_frame.trace.trace_enabled_QMARK_\" true} in :closure-defines. See: https://github.com/day8/re-frame-10x#installation."], 0));
}
});
re_frame.trace.remove_trace_cb = (function re_frame$trace$remove_trace_cb(key){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(re_frame.trace.trace_cbs,cljs.core.dissoc,key);

return null;
});
re_frame.trace.next_id = (function re_frame$trace$next_id(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(re_frame.trace.id,cljs.core.inc);
});
re_frame.trace.start_trace = (function re_frame$trace$start_trace(p__27747){
var map__27748 = p__27747;
var map__27748__$1 = (((((!((map__27748 == null))))?(((((map__27748.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27748.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__27748):map__27748);
var operation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27748__$1,new cljs.core.Keyword(null,"operation","operation",-1267664310));
var op_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27748__$1,new cljs.core.Keyword(null,"op-type","op-type",-1636141668));
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27748__$1,new cljs.core.Keyword(null,"tags","tags",1771418977));
var child_of = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27748__$1,new cljs.core.Keyword(null,"child-of","child-of",-903376662));
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"id","id",-1388402092),re_frame.trace.next_id(),new cljs.core.Keyword(null,"operation","operation",-1267664310),operation,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),op_type,new cljs.core.Keyword(null,"tags","tags",1771418977),tags,new cljs.core.Keyword(null,"child-of","child-of",-903376662),(function (){var or__4126__auto__ = child_of;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_);
}
})(),new cljs.core.Keyword(null,"start","start",-355208981),re_frame.interop.now()], null);
});
re_frame.trace.debounce_time = (50);
re_frame.trace.debounce = (function re_frame$trace$debounce(f,interval){
return goog.functions.debounce(f,interval);
});
re_frame.trace.schedule_debounce = re_frame.trace.debounce((function re_frame$trace$tracing_cb_debounced(){
var seq__27750_27798 = cljs.core.seq(cljs.core.deref(re_frame.trace.trace_cbs));
var chunk__27752_27799 = null;
var count__27753_27800 = (0);
var i__27754_27801 = (0);
while(true){
if((i__27754_27801 < count__27753_27800)){
var vec__27766_27802 = chunk__27752_27799.cljs$core$IIndexed$_nth$arity$2(null,i__27754_27801);
var k_27803 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27766_27802,(0),null);
var cb_27804 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27766_27802,(1),null);
try{var G__27771_27806 = cljs.core.deref(re_frame.trace.traces);
(cb_27804.cljs$core$IFn$_invoke$arity$1 ? cb_27804.cljs$core$IFn$_invoke$arity$1(G__27771_27806) : cb_27804.call(null,G__27771_27806));
}catch (e27770){var e_27807 = e27770;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_27803,"while storing",cljs.core.deref(re_frame.trace.traces),e_27807], 0));
}

var G__27808 = seq__27750_27798;
var G__27809 = chunk__27752_27799;
var G__27810 = count__27753_27800;
var G__27811 = (i__27754_27801 + (1));
seq__27750_27798 = G__27808;
chunk__27752_27799 = G__27809;
count__27753_27800 = G__27810;
i__27754_27801 = G__27811;
continue;
} else {
var temp__5735__auto___27813 = cljs.core.seq(seq__27750_27798);
if(temp__5735__auto___27813){
var seq__27750_27816__$1 = temp__5735__auto___27813;
if(cljs.core.chunked_seq_QMARK_(seq__27750_27816__$1)){
var c__4556__auto___27817 = cljs.core.chunk_first(seq__27750_27816__$1);
var G__27818 = cljs.core.chunk_rest(seq__27750_27816__$1);
var G__27819 = c__4556__auto___27817;
var G__27820 = cljs.core.count(c__4556__auto___27817);
var G__27821 = (0);
seq__27750_27798 = G__27818;
chunk__27752_27799 = G__27819;
count__27753_27800 = G__27820;
i__27754_27801 = G__27821;
continue;
} else {
var vec__27772_27822 = cljs.core.first(seq__27750_27816__$1);
var k_27823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27772_27822,(0),null);
var cb_27824 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27772_27822,(1),null);
try{var G__27776_27826 = cljs.core.deref(re_frame.trace.traces);
(cb_27824.cljs$core$IFn$_invoke$arity$1 ? cb_27824.cljs$core$IFn$_invoke$arity$1(G__27776_27826) : cb_27824.call(null,G__27776_27826));
}catch (e27775){var e_27827 = e27775;
re_frame.loggers.console.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error thrown from trace cb",k_27823,"while storing",cljs.core.deref(re_frame.trace.traces),e_27827], 0));
}

var G__27828 = cljs.core.next(seq__27750_27816__$1);
var G__27829 = null;
var G__27830 = (0);
var G__27831 = (0);
seq__27750_27798 = G__27828;
chunk__27752_27799 = G__27829;
count__27753_27800 = G__27830;
i__27754_27801 = G__27831;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_(re_frame.trace.traces,cljs.core.PersistentVector.EMPTY);
}),re_frame.trace.debounce_time);
re_frame.trace.run_tracing_callbacks_BANG_ = (function re_frame$trace$run_tracing_callbacks_BANG_(now){
if(((cljs.core.deref(re_frame.trace.next_delivery) - (25)) < now)){
(re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0 ? re_frame.trace.schedule_debounce.cljs$core$IFn$_invoke$arity$0() : re_frame.trace.schedule_debounce.call(null));

return cljs.core.reset_BANG_(re_frame.trace.next_delivery,(now + re_frame.trace.debounce_time));
} else {
return null;
}
});

//# sourceMappingURL=re_frame.trace.js.map
