/*
 * Decompiled with CFR 0.152.
 */
package server.parsers;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import server.parsers.BasicRequestParser;
import server.parsers.ParserHelper;

public class RequestParamsParser
extends BasicRequestParser {
    public Map<String, String> parse(byte[] byArray) throws UnsupportedEncodingException {
        if (byArray == null) {
            return new HashMap<String, String>();
        }
        String string = this.findAction(byArray);
        String string2 = "";
        if (string.contains("GET")) {
            string2 = this.findQueryString(byArray);
        } else if (string.contains("PUT") || string.contains("POST")) {
            string2 = this.findFormString(byArray);
        }
        return this.parseParams(string2);
    }

    private String findQueryString(byte[] byArray) {
        String string = ParserHelper.parseQuery(byArray, "\r\n\r\n");
        String string2 = ParserHelper.splitOnParameter(string, "\r\n", 0);
        String string3 = ParserHelper.splitOnParameter(string2, " ", 1);
        return string3.contains("?") ? string3.split("\\?")[1] : "";
    }

    private String findAction(byte[] byArray) {
        String string = ParserHelper.parseQuery(byArray, "\r\n\r\n");
        String string2 = ParserHelper.splitOnParameter(string, "\r\n", 0);
        return ParserHelper.splitOnParameter(string2, " ", 0);
    }

    private String findFormString(byte[] byArray) throws UnsupportedEncodingException {
        String string = new String(byArray, "UTF-8");
        return ParserHelper.splitOnParameter(string, "\r\n\r\n", 1);
    }

    private Map<String, String> parseParams(String string) throws UnsupportedEncodingException {
        Map<String, String> map = new HashMap<String, String>();
        if (string.contains("&")) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("&")) {
                map = this.putArgAndValue(map, string2);
            }
        } else {
            map = this.putArgAndValue(map, string);
        }
        return map;
    }

    private Map<String, String> putArgAndValue(Map<String, String> map, String string) throws UnsupportedEncodingException {
        if (string.contains("=")) {
            String[] stringArray = string.split("=");
            map.put(this.decode(stringArray[0]), this.decode(stringArray[1]));
        }
        return map;
    }

    private String decode(String string) throws UnsupportedEncodingException {
        return URLDecoder.decode(string, "ASCII");
    }
}

