/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import server.Response;

public class ResponseFormatter {
    public byte[] formatResponse(Response response) throws IOException {
        return this.combine(this.findHeader(response).getBytes(), response.getBody());
    }

    private String findHeader(Response response) {
        return "HTTP/1.1 " + this.formatStatus(response) + this.formatHeaders(response) + "\r\n";
    }

    private byte[] combine(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.write(byArray2);
        return byteArrayOutputStream.toByteArray();
    }

    private String formatHeaders(Response response) {
        String string = "";
        for (Map.Entry<String, String> entry : response.getHeaders().entrySet()) {
            string = string + entry.getKey() + ": " + entry.getValue() + "\r\n";
        }
        return string;
    }

    private String formatStatus(Response response) {
        return String.valueOf(response.getStatusCode()) + " " + this.findStatusMessage(response.getStatusCode());
    }

    private String findStatusMessage(int n) {
        Map<Integer, String> map = this.defaultMessages();
        return map.get(n) + "\r\n";
    }

    private Map<Integer, String> defaultMessages() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(200, "OK");
        hashMap.put(204, "NO CONTENT");
        hashMap.put(404, "NOT FOUND");
        hashMap.put(405, "METHOD NOT ALLOWED");
        hashMap.put(500, "INTERNAL ERROR");
        return hashMap;
    }
}

