/*
 * Decompiled with CFR 0.152.
 */
package server;

import java.io.Closeable;
import java.io.IOException;
import server.Connectable;
import server.Handler;
import server.Request;
import server.Response;
import server.ResponseFormatter;
import server.parsers.RequestParser;

public class Connection
implements Runnable,
Closeable {
    private Connectable connectable;
    private Handler handler;

    public Connection(Connectable connectable, Handler handler) {
        this.connectable = connectable;
        this.handler = handler;
    }

    @Override
    public void run() {
        Request request = this.read();
        Response response = null;
        try {
            response = this.handler.handle(request);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.write(response);
        this.close();
    }

    public Request read() {
        Request request = null;
        try {
            request = new RequestParser().parse(this.connectable.getInputStream());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return request;
    }

    public void write(Response response) {
        try {
            this.connectable.getOutputStream().write(new ResponseFormatter().formatResponse(response));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void close() {
        try {
            this.connectable.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

