/*
 * Decompiled with CFR 0.152.
 */
package server.staticFileHandlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import server.Handler;
import server.Request;
import server.Response;

public class PartialContentHandler
implements Handler {
    private File root;

    public PartialContentHandler(File file) {
        this.root = file;
    }

    @Override
    public Response handle(Request request) throws IOException {
        Map<String, Integer> map = this.findRange(request);
        byte[] byArray = this.readPartialContent(request, map);
        String string = this.findRangeHeader(request, map);
        return new Response(206).setBody(byArray).setHeader("Content-Range", string);
    }

    private String findRangeHeader(Request request, Map<String, Integer> map) throws IOException {
        byte[] byArray = this.readFile(this.currentFile(request));
        return "bytes " + new String(String.valueOf(map.get("start"))) + "-" + new String(String.valueOf(map.get("end"))) + "/" + byArray.length;
    }

    private byte[] readPartialContent(Request request, Map<String, Integer> map) throws IOException {
        byte[] byArray = this.readFile(this.currentFile(request));
        int n = map.get("end") - map.get("start");
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i + map.get("start")];
        }
        return byArray2;
    }

    private Map<String, Integer> findRange(Request request) throws IOException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = this.findStart(request);
        int n2 = this.findEnd(request);
        hashMap.put("start", n);
        hashMap.put("end", n2);
        return hashMap;
    }

    private int findStart(Request request) throws IOException {
        String string;
        byte[] byArray = this.readFile(this.currentFile(request));
        if (this.fieldValue(request).contains("=") && (string = this.fieldValue(request).split("=")[1]).contains("-")) {
            String[] stringArray = string.split("-");
            if (string.startsWith("-")) {
                return byArray.length - Integer.parseInt(stringArray[1]);
            }
            return Integer.parseInt(stringArray[0]);
        }
        return 0;
    }

    private int findEnd(Request request) throws IOException {
        String string;
        byte[] byArray = this.readFile(this.currentFile(request));
        if (this.fieldValue(request).contains("=") && (string = this.fieldValue(request).split("=")[1]).contains("-")) {
            String[] stringArray = string.split("-");
            if (string.endsWith("-") || stringArray[0].equals("")) {
                return byArray.length;
            }
            return Integer.parseInt(stringArray[1]) + 1;
        }
        return byArray.length;
    }

    private String fieldValue(Request request) {
        return request.getHeader("Range");
    }

    private File currentFile(Request request) {
        return new File(this.root.getPath().concat(request.getPath()));
    }

    private byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(Paths.get(file.getPath(), new String[0]));
    }
}

