(ns mdsync.core
  (:require [clojure.string :as string]))

(defn clean-name [filename]
  (let [end (- (count filename) 3)
        start (inc (or (string/index-of filename "+") -1))]
    (subs filename start end)))

(defn filename [file]
  (-> file
      .toPath
      .getFileName
      .toString))

(defn env-val [env-name]
  (let [env-val (System/getenv env-name)]
    (when (nil? env-val)
      (throw (ex-info (str "env var not found " env-name)
                      {:env-var env-name})))
    env-val))
