(ns leiningen.equilibrium
  (:require [equilibrium.render :as render]
            [equilibrium.miner.ftp :as ftp]
            [leiningen.core.main :refer [info warn]]
            [clojure.java.io :as io]))

(defn deploy
  "Deploys the rendered page under target/page to the configured ftp target"
  [project]
  (ftp/with-ftp [client (System/getenv "MDSYNC_URL")
                 :ftp-user (System/getenv "MDSYNC_USER")
                 :ftp-pass (System/getenv "MDSYNC_PASS")]
    (doseq [file (file-seq (io/file "target/page"))
            :let [fname (str file)
                  relpath (subs fname (count "target/page"))
                  dir? (.isDirectory file)]
            :when (pos? (count relpath))]
      (let [dest (subs relpath 1)]
        (if dir?
          (do
            (println "creating dir" dest)
            (ftp/client-mkdir client dest))
          (do
            (println fname "to" dest)
            (ftp/client-put client fname dest)))))))

(defn invalid-input [project]
  (warn "refer to 'lein help equilibrium' for available tasks"))

(def argmapping
  {:render render/render
   :deploy deploy
   :? invalid-input})

(defn equilibrium
  {:subtasks [#'render/render #'deploy]}
  [project & args]
  (let [kwarg (keyword (or (first args) "?"))
        callfn (kwarg argmapping invalid-input)]
    (callfn project)))
