(ns leiningen.neo4j
  (:import org.neo4j.server.CommunityBootstrapper
           java.lang.Thread
           java.util.Optional)
  (:require [clojure.java.io :as io]))

(defn neo4j
  [project & args]
  (let [path (io/as-file (get-in project [:neo4j :path] "target/neo4j"))
        config (get-in project [:neo4j :config] {})
        server (CommunityBootstrapper.)]
    (.start server path (Optional/empty) config)
    (while true (Thread/sleep 5000))))

(defn with-db [& {:keys [path config do-with-db]
               :or {:path "target/neo4j"
                    :config {}}}]
  (let [server (CommunityBootstrapper.)]
    (.start server path (Optional/empty) config)
    (do-with-db)
    (.stop server)))
