(ns leiningen.neo4j
  (:import org.neo4j.server.CommunityBootstrapper
           org.neo4j.test.TestGraphDatabaseFactory
           java.lang.Thread
           java.util.Optional)
  (:require [clojure.java.io :as io]))

(defn neo4j
  [project & args]
  (let [path (io/as-file (get-in project [:neo4j :path] "target/neo4j"))
        config (get-in project [:neo4j :config] {})
        server (CommunityBootstrapper.)]
    (.start server path (Optional/empty) config)
    (while true (Thread/sleep 5000))))

(defn with-test-db [path do-with-db]
  (let [db (.newImpermanentDatabase
           (TestGraphDatabaseFactory.)
           (io/as-file path))]
    (do-with-db)))
