(ns leiningen.neo4j
  (:import org.neo4j.graphdb.factory.GraphDatabaseFactory
           org.neo4j.server.CommunityBootstrapper
           java.lang.Runtime
           java.lang.Thread
           java.util.Optional)
  (:require [clojure.java.io :as io]))

(defn neo4j
  [project & args]
  (let [path (io/as-file (get-in project [:neo4j :path] "target/neo4j"))
        config (get-in project [:neo4j :config] {})
        server (CommunityBootstrapper.)]
    (.start server path (Optional/empty) config)
    (while true (Thread/sleep 10000))))
