(ns joplin.main
  (:use [clojure.tools.cli :only (cli)])
  (:require [ragtime.main :as ragtime]
            [clojure.string :as str])))

(defn- parse-args [args]
  (cli args
       ["-r" "--require"]
       ["-e" "--environments"]
       ["-d" "--databases"]
       ["-m" "--migrators"]
       ["-s" "--seeds"]))

(def help-text
  "Manage Joplin migrations and seeds.

Commands:
migrate env/db        Migrate to the latest version
rollback db [n]       Rollback n versions (defaults to 1)
seed env/db           Seed and environment with data
reset env/db          Re-apply all migrations and/or seeds

Options:
-r  --require     Comma-separated list of namespaces to require")

(defn -main
  "Migrates a database to the latest version when supplied with a database URL
  and a function that returns a sequence of migrations."
  [& args]
  (let [[options [command & args]] (parse-args args)]
    (println )
    (doseq [ns (ragtime/parse-namespaces options)]
      (require ns))
    (case command
      "migrate"  (apply ragtime/migrate options args)
      "rollback" (apply ragtime/rollback options args)
      "help"     (println help-text)
      :else      (do (println help-text)
                     (System/exit 1)))))
