(ns nightclub.example
  (:require [nightcode.customizations :as custom]
            [nightcode.editors :as editors]
            [nightcode.projects :as projects]
            [nightcode.utils :as utils]
            [nightcode.sandbox :as sandbox]
            [nightcode.repl :as repl]
            [nightcode.shortcuts :as shortcuts]
            [nightcode.ui :as ui]
            [nightcode.window :as window]
            [seesaw.core :as s]))

(defn menu! []
  (let [open-action (s/action
                     :handler (fn [e] (s/alert "I should open a new something."))
                     :name "Open ..."
                     :key  "menu O"
                     :tip  "Open a new something something.")
        exit-action (s/action
                   :handler (fn [e] (.dispose (s/to-frame e)))
                   :name "Exit"
                   :tip  "Close this window")]
    (s/show! (s/frame :title "MENUS!"
                      :menubar 
                      (s/menubar :items 
                                 [(s/menu :text "File" :items [open-action])
                                  (s/menu :text "Edit" :items [exit-action])])))))
