(ns thingies.clock
  (:require [clj-time.core :as t]
            [clj-time.coerce :as c]))

;;;; CLOCK
(defprotocol Clock
  (now [this]))

(defrecord JodaClock []
  Clock
  (now [this]
    (c/to-long (t/now))))

(defn new-joda-clock []
  (JodaClock. ))

;;;;; STUB CLOCK
(defprotocol ITestClock
  (adjust [this new-time]))

(defrecord TestClock [time-atom]
  Clock
  (now [this]
    @time-atom)
  ITestClock
  (adjust [this new-time]
    (swap! time-atom (constantly new-time))))

(defn new-test-clock [t]
  (TestClock. (atom t)))
