(ns jlk.math.apache.complex
  (:require [jlk.math.core :as core]
            [jlk.math.generic :as generic]
            [jlk.math.double :as double])
  (:import [org.apache.commons.math3.complex Complex ComplexField ComplexUtils]))

(def ZERO org.apache.commons.math3.complex.Complex/ZERO)
(def ONE org.apache.commons.math3.complex.Complex/ONE)
;; (compile 'jlk.math.Complex)

(defn -complex-dispatch [& _] @core/*complex-mode*)
(defmulti complex -complex-dispatch)

(defmethod complex :polar
  ([mod]
     (ComplexUtils/polar2Complex mod 0.0))
  ([mod arg]
     (ComplexUtils/polar2Complex mod (core/parse-angle arg))))

(defmethod complex :rectangular
  ([re]
     (Complex. re))
  ([re im]
     (Complex. re im)))

(defn -generic-dispatch [_ & args] (type (first args)))

(defmulti add -generic-dispatch)
(defmethod add nil [x] x)
(defmethod add Complex [x y] (.add x y))
(defmethod add Double [x y] (.add x y))
(defmethod add Long [x y] (.add x (double y)))
(defmethod add clojure.lang.Ratio [x y] (.add x (double y)))
(defmethod generic/add Complex [& args] (apply add args))
(defmethod double/add Complex [x y] (.add y x)) ;; order is not important

(defmulti sub -generic-dispatch)
(defmethod sub nil [x] (.negate x))
(defmethod sub Complex [x y] (.subtract x y))
(defmethod sub Double [x y] (.subtract x y))
(defmethod sub Long [x y] (.subtract x (double y)))
(defmethod sub clojure.lang.Ratio [x y] (.subtract x (double y)))
(defmethod generic/sub Complex [& args] (apply sub args))
(defmethod double/sub Complex [x y] (sub (complex x) y)) ;; promote x to complex

(defn real [z] (.getReal z))
(defmethod generic/real Complex [z] (real z))

(defn imag [z] (.getImaginary z))
(defmethod generic/imag Complex [z] (imag z))

;; (defn abs [z] (.abs z))
;; (def modulus abs)
;; (def mod abs)
;; (def norm abs)

;; (defn arg [z] (.getArgument z))
;; (def phase arg)

;; (defn polar
;;   ([z] (polar z @*angle-mode*))
;;   ([z format]
;;      (case format
;;        :degrees [(abs z) (Math/toDegrees (arg z))]
;;        :deg [(abs z) (Math/toDegrees (arg z))]
;;        :radians [(abs z) (arg z)]
;;        :rad [(abs z) (arg z)]
;;        (exception "complex: unrecognised format %s" format))))

;; (defn conjugate
;;   [z] (.conjugate z))

;; (defn subtract
;;   ([x] (.negate x))
;;   ([x y] (.subtract x y))
;;   ([x y & rest] (reduce subtract (subtract x y) rest)))
;; (def sub subtract)
;; (def - sub)

;; (defn multiply
;;   ([] ONE)
;;   ([x] x)
;;   ([x y] (.multiply x y))
;;   ([x y & rest] (reduce multiply (multiply x y) rest)))
;; (def mul multiply)
;; (def * multiply)

;; (defn divide
;;   ([x] (.reciprocal x))
;;   ([x y] (.divide x y))
;;   ([x y & rest] (reduce divide (divide x y) rest)))
;; (def div divide)
;; (def / divide)

;; (defn square [x] (* x x))
;; (defn square-root [x] (.sqrt x))
;; (defn cube [x] (* x x x))
;; (defn cube-root [x] (.pow x (double 1/3)))
;; (defn power [x y] (.pow x y))
;; (defn nth-root [x y] (seq (.nthRoot x y)))

;; (defn exp [x] (.exp x))
;; (defn ln [x] (.log x))

;; (defn sin [x] (.sin x))
;; (defn cos [x] (.cos x))
;; (defn tan [x] (.tan x))
;; (defn asin [x] (.asin x))
;; (defn acos [x] (.acos x))
;; (defn atan [x] (.atan x))

;; (defn sinh [x] (.sinh x))
;; (defn cosh [x] (.cosh x))
;; (defn tanh [x] (.tanh x))

;; ;; (defn assoc-complex-literals!
;; ;;   []
;; ;;   (set! *data-readers* (assoc *data-readers* 'blah 'complex2)))
