(ns jlk.fs.filter
  (:refer-clojure :exclude [re-matches re-find])
  (:require [jlk.fs.core :as core]))

(defn starts-with
  [s]
  (fn [x] (.startsWith (core/name x) s)))

(defn re-matches
  [re]
  (fn [x] (re-matches re (core/name x))))

(defn re-find
  [re]
  (fn [x] (re-find re (core/name x))))

;; (defn filter-type
;;   [t]
;;   (fn [x] (= (:type (type x)) t)))

(defn extension
  [ext & {:keys [case] :or {case :insensitive}}]
  (fn [x] (and (= (core/type x) "f")
               (clojure.core/case case
                                  :insensitive (= (.toLowerCase (core/extension x))
                                                  (.toLowerCase ext))
                                  :sensitive (= (core/extension x)
                                                ext)))))

(defn to-java
  [func]
  (org.apache.commons.io.filefilter.DelegateFileFilter.
   (proxy [java.io.FileFilter] []
     (accept [file] (func file)))))

;; (ns jlk.ddb2.filter
;;   (:refer-clojure :exclude [and or])
;;   (:import [org.apache.commons.io.filefilter FileFilterUtils IOFileFilter]
;;            [org.apache.commons.io IOCase]))

;; ;;
;; ;;(require [jlk.ddb2.filter :as filter])
;; ;;

;; (defn suffix
;;   [s & {:keys [case] :or {case :insensitive}}]
;;   (FileFilterUtils/suffixFileFilter s (clojure.core/case case
;;                                                          :sensitive IOCase/SENSITIVE
;;                                                          :insensitive IOCase/INSENSITIVE
;;                                                          :system IOCase/SYSTEM)))

;; (defn and
;;   [& list] (FileFilterUtils/and (into-array IOFileFilter list)))

;; (defn or
;;   [& list] (FileFilterUtils/or (into-array IOFileFilter list)))
