(ns jlk.data.office.csv
  (:require [clojure.data.csv :as csv]
            [clojure.java.io :as io]))

;;
;; formats:
;; 
;; dta - [[r0c0 r0c1], [r1c0 r1c1], ...]
;; table  - [{:heading_one r1c0 :heading_two r1c1} ...]
;;

(defn read-file
  "read csv file into memory"
  [f & {:keys [cast-fn]}]
  (with-open [r (io/reader f)]
    (doall
     (csv/read-csv r))))

(defn write-file
  "write csv file to file"
  [f dta]
  (with-open [w (io/writer f)]
    (csv/write-csv w dta)))

(defn get-at
  "get a value from position ri, ci.  :header=true means first row is ignored"
  [dta ri ci & {:keys [header]}]
  (if header
    (nth (nth dta (inc ri)) ci)
    (nth (nth dta ri) ci)))

(defn to-table
  "take the dta definition and return a table definition.  see jlk.table"
  [dta]
  (let [headers (map keyword (first dta))
        rows (rest dta)]
    :columns (map (fn [h] {:key h :text h}) headers)
    :rows (map (fn [row] (zipmap headers row)) rows)))
