(ns libapl-clj.impl.util
  (:require libapl-clj.impl.protocols)
  )

(defn ^:private random-var-name []
  (clojure.string/replace (str "a" (UUID/randomUUID))  #"-" ""))

(defn drawing [apl-value-or-tensor]
  (let [drawing-name    (random-var-name)
        tensor?         (tensor/tensor? apl-value-or-tensor)
        apl-name        (if tensor?
                          (-> apl-value-or-tensor meta :apl/name)
                          (let [apl-name (random-var-name)]
                            (jna/set_var_value apl-name apl-value-or-tensor "")
                            apl-name))
        apl-value       (if tensor?
                          (jna/get_var_value apl-name "")
                          apl-value-or-tensor)
        drawing-pointer (do  (apl/run-simple-string! (str drawing-name " ← 4 ⎕CR " apl-name))
                             (apl/value-pointer drawing-name))
        sb              (StringBuilder.)
        res             (jna/print_value_to_string drawing-pointer)]
    (future
      (when-not tensor?
        (jna/apl_command (str "ERASE " apl-name)))
      (jna/apl_command (str "ERASE " drawing-pointer)))
    (PTensor. drawing-pointer)))
