(ns libapl-clj.impl.pointer
  (:refer-clojure :exclude [- = * > < / + -])
  (:require [libapl-clj.impl.jna :as jna]
            tech.v3.datatype.jna ;; <-- this is criticial
            [tech.v3.datatype :as dtype]
            [libapl-clj.impl.api :as api])
  (:import [com.sun.jna Pointer]))


(defn ^:private getfn
  "Import an APL function into Clojure as a pointer"
  ^Pointer [^String fstring]
  (api/get-function-ucs fstring))

(def + (getfn '+))
(def - (getfn '-))
(def × (getfn '×))
(def = (getfn '=))
(def ÷ (getfn '÷))
(def * (getfn '*))
(def ⌈ (getfn '⌈))
(def ⌊ (getfn '⌊))
(def | (getfn '|))
(def < (getfn '<))
(def ≤ (getfn '≤))
(def = (getfn '=))
(def > (getfn '>))
(def ≥ (getfn '≥))
(def ≠ (getfn '≠))
(def ⍴ (getfn '⍴))
(def ∊ (getfn '∊))
(def ∨ (getfn '∨))
(def ∧ (getfn '∧))
(def ⍱ (getfn '⍱))
(def ⍲ (getfn '⍲))
(def ... (getfn ","))
(def ⍪ (getfn '⍪))
(def / (getfn '/))
(def ⌿ (getfn '⌿))
(def ⍳ (getfn '⍳))
(def ⌷ (getfn '⌷))
(def ⍕ (getfn '⍕))
(def ⍎ (getfn '⍎))
(def ∼ (getfn '∼))
(def ↑ (getfn '↑))
(def ↓ (getfn '↓))
(def backslash (getfn "\\"))
(def ⌽ (getfn '⌽))
(def ⍉ (getfn '⍉))
(def ⊖ (getfn '⊖))
(def ¯ (getfn '¯))
(def ⍬ (getfn '⍬))
(def ← (getfn '←))
(def → (getfn '→))
;; (def ⍞ (getfn "⍞"))
(def hashtag (getfn "#"))
;; (def ⎕ (getfn "⎕"))
(def ⍋ (getfn '⍋))
(def ⍒ (getfn '⍒))
(def ⊥ (getfn '⊥))
(def ⊤ (getfn '⊤))
(def ? (getfn '?))
(def ⍟ (getfn '⍟))
(def ! (getfn '!))
(def ○ (getfn '○))
(def ⌹ (getfn '⌹))
(def ∩ (getfn '∩))
(def ∪ (getfn '∪))
(def ≡ (getfn '≡))
(def ≢ (getfn '≢))
(def ¨ (getfn '¨))
(def ∘. (getfn '∘.)) ;; ⍝ not sure if this will work
(def ⍤ (getfn '⍤))
(def . (getfn '.))
(def ⍳ (getfn '⍳))
(def ⍷ (getfn '⍷))
(def ⊣ (getfn '⊣))
(def ⊢ (getfn '⊢))
(def ⊂ (getfn '⊂))
(def ⊃ (getfn '⊃))
