// Compiled by ClojureScript 1.7.170 {}
goog.provide('petrol.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('clojure.set');
/**
 * Apply a function to every element that comes out of a channel.
 * 
 *   (This is fmap for channels).
 */
petrol.core.wrap = (function petrol$core$wrap(f,in$){
return cljs.core.async.pipe.call(null,in$,cljs.core.async.chan.call(null,(1),cljs.core.map.call(null,f)));
});
/**
 * Apply a function to every element that goes into a channel.
 * 
 *   (This is contramap for channels).
 */
petrol.core.forward = (function petrol$core$forward(f,from){
var to = cljs.core.async.chan.call(null);
var c__19002__auto___24415 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto___24415,to){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto___24415,to){
return (function (state_24404){
var state_val_24405 = (state_24404[(1)]);
if((state_val_24405 === (1))){
var state_24404__$1 = state_24404;
var statearr_24406_24416 = state_24404__$1;
(statearr_24406_24416[(2)] = null);

(statearr_24406_24416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24405 === (2))){
var state_24404__$1 = state_24404;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24404__$1,(5),to);
} else {
if((state_val_24405 === (3))){
var inst_24402 = (state_24404[(2)]);
var state_24404__$1 = state_24404;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24404__$1,inst_24402);
} else {
if((state_val_24405 === (4))){
var inst_24400 = (state_24404[(2)]);
var state_24404__$1 = state_24404;
var statearr_24407_24417 = state_24404__$1;
(statearr_24407_24417[(2)] = inst_24400);

(statearr_24407_24417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24405 === (5))){
var inst_24397 = (state_24404[(2)]);
var inst_24398 = f.call(null,inst_24397);
var state_24404__$1 = state_24404;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24404__$1,(4),from,inst_24398);
} else {
return null;
}
}
}
}
}
});})(c__19002__auto___24415,to))
;
return ((function (switch__18890__auto__,c__19002__auto___24415,to){
return (function() {
var petrol$core$forward_$_state_machine__18891__auto__ = null;
var petrol$core$forward_$_state_machine__18891__auto____0 = (function (){
var statearr_24411 = [null,null,null,null,null,null,null];
(statearr_24411[(0)] = petrol$core$forward_$_state_machine__18891__auto__);

(statearr_24411[(1)] = (1));

return statearr_24411;
});
var petrol$core$forward_$_state_machine__18891__auto____1 = (function (state_24404){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_24404);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e24412){if((e24412 instanceof Object)){
var ex__18894__auto__ = e24412;
var statearr_24413_24418 = state_24404;
(statearr_24413_24418[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24404);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24412;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24419 = state_24404;
state_24404 = G__24419;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
petrol$core$forward_$_state_machine__18891__auto__ = function(state_24404){
switch(arguments.length){
case 0:
return petrol$core$forward_$_state_machine__18891__auto____0.call(this);
case 1:
return petrol$core$forward_$_state_machine__18891__auto____1.call(this,state_24404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
petrol$core$forward_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = petrol$core$forward_$_state_machine__18891__auto____0;
petrol$core$forward_$_state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = petrol$core$forward_$_state_machine__18891__auto____1;
return petrol$core$forward_$_state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto___24415,to))
})();
var state__19004__auto__ = (function (){var statearr_24414 = f__19003__auto__.call(null);
(statearr_24414[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto___24415);

return statearr_24414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto___24415,to))
);


return to;
});

/**
 * @interface
 */
petrol.core.Message = function(){};

/**
 * Given a message, take the current app state and
 *                 return the new one. In essense this is a reducing
 *                 function.
 */
petrol.core.process_message = (function petrol$core$process_message(message,app){
if((!((message == null))) && (!((message.petrol$core$Message$process_message$arity$2 == null)))){
return message.petrol$core$Message$process_message$arity$2(message,app);
} else {
var x__17490__auto__ = (((message == null))?null:message);
var m__17491__auto__ = (petrol.core.process_message[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,message,app);
} else {
var m__17491__auto____$1 = (petrol.core.process_message["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,message,app);
} else {
throw cljs.core.missing_protocol.call(null,"Message.process-message",message);
}
}
}
});


/**
 * @interface
 */
petrol.core.EventSource = function(){};

petrol.core.watch_channels = (function petrol$core$watch_channels(message,app){
if((!((message == null))) && (!((message.petrol$core$EventSource$watch_channels$arity$2 == null)))){
return message.petrol$core$EventSource$watch_channels$arity$2(message,app);
} else {
var x__17490__auto__ = (((message == null))?null:message);
var m__17491__auto__ = (petrol.core.watch_channels[goog.typeOf(x__17490__auto__)]);
if(!((m__17491__auto__ == null))){
return m__17491__auto__.call(null,message,app);
} else {
var m__17491__auto____$1 = (petrol.core.watch_channels["_"]);
if(!((m__17491__auto____$1 == null))){
return m__17491__auto____$1.call(null,message,app);
} else {
throw cljs.core.missing_protocol.call(null,"EventSource.watch-channels",message);
}
}
}
});

petrol.core.process_submessage = (function petrol$core$process_submessage(submessage,app,path){
if(((!((submessage == null)))?(((false) || (submessage.petrol$core$Message$))?true:(((!submessage.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,petrol.core.Message,submessage):false)):cljs.core.native_satisfies_QMARK_.call(null,petrol.core.Message,submessage))){
return cljs.core.update_in.call(null,app,path,(function (p1__24420_SHARP_){
return petrol.core.process_message.call(null,submessage,p1__24420_SHARP_);
}));
} else {
return null;
}
});
petrol.core.watch_subchannels = (function petrol$core$watch_subchannels(submessage,app,path,wrapper){
if(((!((submessage == null)))?(((false) || (submessage.petrol$core$EventSource$))?true:(((!submessage.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,petrol.core.EventSource,submessage):false)):cljs.core.native_satisfies_QMARK_.call(null,petrol.core.EventSource,submessage))){
return cljs.core.map.call(null,(function (p1__24423_SHARP_){
return petrol.core.wrap.call(null,wrapper,p1__24423_SHARP_);
}),petrol.core.watch_channels.call(null,submessage,cljs.core.get_in.call(null,app,path)));
} else {
return null;
}
});
/**
 * Given a DOM event, return the value it yields. This abstracts over
 *   the needless inconsistencies of the DOM.
 */
petrol.core.get_event_value = (function petrol$core$get_event_value(event){
var target = event.target;
var type = target.type;
var pred__24429 = cljs.core.contains_QMARK_;
var expr__24430 = type;
if(cljs.core.truth_(pred__24429.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["checkbox",null], null), null),expr__24430))){
return target.checked;
} else {
if(cljs.core.truth_(pred__24429.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 19, ["range",null,"select-one",null,"url",null,"tel",null,"email",null,"radio",null,"text",null,"number",null,"week",null,"time",null,"select-multiple",null,"datetime",null,"textarea",null,"password",null,"date",null,"month",null,"datetime-local",null,"search",null,"color",null], null), null),expr__24430))){
return target.value;
} else {
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__24430)].join('')));
}
}
});
/**
 * Send information from the user to the message queue.
 *   The message must be a record which implements the Message protocol.
 */
petrol.core.send_BANG_ = (function petrol$core$send_BANG_(channel,message){
return (function (dom_event){
cljs.core.async.put_BANG_.call(null,channel,message);

return dom_event.stopPropagation();
});
});
/**
 * Send information from the user to the message queue.
 * 
 *   Similar to `send!`, except the message-fn will be called with the message's value first.
 */
petrol.core.send_value_BANG_ = (function petrol$core$send_value_BANG_(channel,message_fn){
return (function (dom_event){
cljs.core.async.put_BANG_.call(null,channel,message_fn.call(null,petrol.core.get_event_value.call(null,dom_event)));

return dom_event.stopPropagation();
});
});
/**
 * Send information from the user to the message queue.
 * 
 *   Similar to `send-value!`, except the dom-event's `which` property retrieves the keycode,
 *  and an additional filter function can be supplied by the caller to control which keycodes
 *  are sent on the queue.
 * 
 *  The filterfn returns the keycode if it should be sent, or nil if not.
 */
petrol.core.send_key_BANG_ = (function petrol$core$send_key_BANG_(channel,message_fn,filter_fn){
return (function (dom_event){
var temp__4425__auto___24432 = filter_fn.call(null,dom_event.which);
if(cljs.core.truth_(temp__4425__auto___24432)){
var k_24433 = temp__4425__auto___24432;
cljs.core.async.put_BANG_.call(null,channel,message_fn.call(null,k_24433));
} else {
}

return dom_event.stopPropagation();
});
});
petrol.core._BANG_channels = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
petrol.core.start_message_loop_BANG_ = (function petrol$core$start_message_loop_BANG_(var_args){
var args24435 = [];
var len__17893__auto___24571 = arguments.length;
var i__17894__auto___24572 = (0);
while(true){
if((i__17894__auto___24572 < len__17893__auto___24571)){
args24435.push((arguments[i__17894__auto___24572]));

var G__24573 = (i__17894__auto___24572 + (1));
i__17894__auto___24572 = G__24573;
continue;
} else {
}
break;
}

var G__24437 = args24435.length;
switch (G__24437) {
case 2:
return petrol.core.start_message_loop_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return petrol.core.start_message_loop_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args24435.length)].join('')));

}
});

petrol.core.start_message_loop_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (_BANG_app,render_fn){
return petrol.core.start_message_loop_BANG_.call(null,_BANG_app,render_fn,cljs.core.PersistentHashSet.EMPTY);
});

petrol.core.start_message_loop_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (_BANG_app,render_fn,initial_channels){
cljs.core.reset_BANG_.call(null,petrol.core._BANG_channels,initial_channels);

var ui_channel = cljs.core.async.chan.call(null);
cljs.core.swap_BANG_.call(null,petrol.core._BANG_channels,cljs.core.conj,ui_channel);

cljs.core.add_watch.call(null,_BANG_app,new cljs.core.Keyword(null,"render","render",-1408033454),((function (ui_channel){
return (function (_,___$1,___$2,app){
return render_fn.call(null,ui_channel,app);
});})(ui_channel))
);

cljs.core.swap_BANG_.call(null,_BANG_app,cljs.core.identity);

var c__19002__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__19002__auto__,ui_channel){
return (function (){
var f__19003__auto__ = (function (){var switch__18890__auto__ = ((function (c__19002__auto__,ui_channel){
return (function (state_24515){
var state_val_24516 = (state_24515[(1)]);
if((state_val_24516 === (7))){
var inst_24445 = (state_24515[(7)]);
var inst_24444 = (state_24515[(8)]);
var inst_24444__$1 = (state_24515[(2)]);
var inst_24445__$1 = cljs.core.nth.call(null,inst_24444__$1,(0),null);
var inst_24446 = cljs.core.nth.call(null,inst_24444__$1,(1),null);
var inst_24447 = (inst_24445__$1 == null);
var state_24515__$1 = (function (){var statearr_24517 = state_24515;
(statearr_24517[(7)] = inst_24445__$1);

(statearr_24517[(8)] = inst_24444__$1);

(statearr_24517[(9)] = inst_24446);

return statearr_24517;
})();
if(cljs.core.truth_(inst_24447)){
var statearr_24518_24575 = state_24515__$1;
(statearr_24518_24575[(1)] = (8));

} else {
var statearr_24519_24576 = state_24515__$1;
(statearr_24519_24576[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (20))){
var inst_24445 = (state_24515[(7)]);
var inst_24444 = (state_24515[(8)]);
var inst_24440 = (state_24515[(10)]);
var inst_24446 = (state_24515[(9)]);
var inst_24475 = (function (){var temp__4425__auto__ = inst_24440;
var cs = inst_24440;
var vec__24442 = inst_24444;
var message = inst_24445;
var channel = inst_24446;
return ((function (temp__4425__auto__,cs,vec__24442,message,channel,inst_24445,inst_24444,inst_24440,inst_24446,state_val_24516,c__19002__auto__,ui_channel){
return (function (p1__24434_SHARP_){
return petrol.core.process_message.call(null,message,p1__24434_SHARP_);
});
;})(temp__4425__auto__,cs,vec__24442,message,channel,inst_24445,inst_24444,inst_24440,inst_24446,state_val_24516,c__19002__auto__,ui_channel))
})();
var inst_24476 = cljs.core.swap_BANG_.call(null,_BANG_app,inst_24475);
var state_24515__$1 = state_24515;
var statearr_24520_24577 = state_24515__$1;
(statearr_24520_24577[(2)] = inst_24476);

(statearr_24520_24577[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (27))){
var inst_24445 = (state_24515[(7)]);
var inst_24488 = inst_24445.cljs$lang$protocol_mask$partition$;
var inst_24489 = (!inst_24488);
var state_24515__$1 = state_24515;
if(cljs.core.truth_(inst_24489)){
var statearr_24521_24578 = state_24515__$1;
(statearr_24521_24578[(1)] = (29));

} else {
var statearr_24522_24579 = state_24515__$1;
(statearr_24522_24579[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (1))){
var state_24515__$1 = state_24515;
var statearr_24523_24580 = state_24515__$1;
(statearr_24523_24580[(2)] = null);

(statearr_24523_24580[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (24))){
var inst_24445 = (state_24515[(7)]);
var inst_24498 = cljs.core.native_satisfies_QMARK_.call(null,petrol.core.EventSource,inst_24445);
var state_24515__$1 = state_24515;
var statearr_24524_24581 = state_24515__$1;
(statearr_24524_24581[(2)] = inst_24498);

(statearr_24524_24581[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (4))){
var inst_24440 = (state_24515[(10)]);
var state_24515__$1 = state_24515;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24515__$1,(7),inst_24440);
} else {
if((state_val_24516 === (15))){
var inst_24445 = (state_24515[(7)]);
var inst_24461 = inst_24445.cljs$lang$protocol_mask$partition$;
var inst_24462 = (!inst_24461);
var state_24515__$1 = state_24515;
if(cljs.core.truth_(inst_24462)){
var statearr_24525_24582 = state_24515__$1;
(statearr_24525_24582[(1)] = (17));

} else {
var statearr_24526_24583 = state_24515__$1;
(statearr_24526_24583[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (21))){
var state_24515__$1 = state_24515;
var statearr_24527_24584 = state_24515__$1;
(statearr_24527_24584[(2)] = null);

(statearr_24527_24584[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (31))){
var inst_24494 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
var statearr_24528_24585 = state_24515__$1;
(statearr_24528_24585[(2)] = inst_24494);

(statearr_24528_24585[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (32))){
var inst_24445 = (state_24515[(7)]);
var inst_24502 = cljs.core.deref.call(null,_BANG_app);
var inst_24503 = petrol.core.watch_channels.call(null,inst_24445,inst_24502);
var inst_24504 = cljs.core.swap_BANG_.call(null,petrol.core._BANG_channels,clojure.set.union,inst_24503);
var state_24515__$1 = state_24515;
var statearr_24529_24586 = state_24515__$1;
(statearr_24529_24586[(2)] = inst_24504);

(statearr_24529_24586[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (33))){
var state_24515__$1 = state_24515;
var statearr_24530_24587 = state_24515__$1;
(statearr_24530_24587[(2)] = null);

(statearr_24530_24587[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (13))){
var inst_24473 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
if(cljs.core.truth_(inst_24473)){
var statearr_24531_24588 = state_24515__$1;
(statearr_24531_24588[(1)] = (20));

} else {
var statearr_24532_24589 = state_24515__$1;
(statearr_24532_24589[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (22))){
var inst_24445 = (state_24515[(7)]);
var inst_24479 = (state_24515[(2)]);
var inst_24481 = (inst_24445 == null);
var inst_24482 = cljs.core.not.call(null,inst_24481);
var state_24515__$1 = (function (){var statearr_24533 = state_24515;
(statearr_24533[(11)] = inst_24479);

return statearr_24533;
})();
if(inst_24482){
var statearr_24534_24590 = state_24515__$1;
(statearr_24534_24590[(1)] = (23));

} else {
var statearr_24535_24591 = state_24515__$1;
(statearr_24535_24591[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (29))){
var inst_24445 = (state_24515[(7)]);
var inst_24491 = cljs.core.native_satisfies_QMARK_.call(null,petrol.core.EventSource,inst_24445);
var state_24515__$1 = state_24515;
var statearr_24536_24592 = state_24515__$1;
(statearr_24536_24592[(2)] = inst_24491);

(statearr_24536_24592[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (6))){
var inst_24511 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
var statearr_24537_24593 = state_24515__$1;
(statearr_24537_24593[(2)] = inst_24511);

(statearr_24537_24593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (28))){
var inst_24496 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
var statearr_24538_24594 = state_24515__$1;
(statearr_24538_24594[(2)] = inst_24496);

(statearr_24538_24594[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (25))){
var inst_24500 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
if(cljs.core.truth_(inst_24500)){
var statearr_24539_24595 = state_24515__$1;
(statearr_24539_24595[(1)] = (32));

} else {
var statearr_24540_24596 = state_24515__$1;
(statearr_24540_24596[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (34))){
var inst_24507 = (state_24515[(2)]);
var state_24515__$1 = (function (){var statearr_24541 = state_24515;
(statearr_24541[(12)] = inst_24507);

return statearr_24541;
})();
var statearr_24542_24597 = state_24515__$1;
(statearr_24542_24597[(2)] = null);

(statearr_24542_24597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (17))){
var inst_24445 = (state_24515[(7)]);
var inst_24464 = cljs.core.native_satisfies_QMARK_.call(null,petrol.core.Message,inst_24445);
var state_24515__$1 = state_24515;
var statearr_24543_24598 = state_24515__$1;
(statearr_24543_24598[(2)] = inst_24464);

(statearr_24543_24598[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (3))){
var inst_24513 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24515__$1,inst_24513);
} else {
if((state_val_24516 === (12))){
var inst_24445 = (state_24515[(7)]);
var inst_24471 = cljs.core.native_satisfies_QMARK_.call(null,petrol.core.Message,inst_24445);
var state_24515__$1 = state_24515;
var statearr_24544_24599 = state_24515__$1;
(statearr_24544_24599[(2)] = inst_24471);

(statearr_24544_24599[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (2))){
var inst_24440 = (state_24515[(10)]);
var inst_24439 = cljs.core.deref.call(null,petrol.core._BANG_channels);
var inst_24440__$1 = cljs.core.seq.call(null,inst_24439);
var state_24515__$1 = (function (){var statearr_24545 = state_24515;
(statearr_24545[(10)] = inst_24440__$1);

return statearr_24545;
})();
if(inst_24440__$1){
var statearr_24546_24600 = state_24515__$1;
(statearr_24546_24600[(1)] = (4));

} else {
var statearr_24547_24601 = state_24515__$1;
(statearr_24547_24601[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (23))){
var inst_24445 = (state_24515[(7)]);
var inst_24484 = inst_24445.petrol$core$EventSource$;
var inst_24485 = (false) || (inst_24484);
var state_24515__$1 = state_24515;
if(cljs.core.truth_(inst_24485)){
var statearr_24548_24602 = state_24515__$1;
(statearr_24548_24602[(1)] = (26));

} else {
var statearr_24549_24603 = state_24515__$1;
(statearr_24549_24603[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (19))){
var inst_24467 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
var statearr_24550_24604 = state_24515__$1;
(statearr_24550_24604[(2)] = inst_24467);

(statearr_24550_24604[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (11))){
var inst_24445 = (state_24515[(7)]);
var inst_24457 = inst_24445.petrol$core$Message$;
var inst_24458 = (false) || (inst_24457);
var state_24515__$1 = state_24515;
if(cljs.core.truth_(inst_24458)){
var statearr_24551_24605 = state_24515__$1;
(statearr_24551_24605[(1)] = (14));

} else {
var statearr_24552_24606 = state_24515__$1;
(statearr_24552_24606[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (9))){
var state_24515__$1 = state_24515;
var statearr_24553_24607 = state_24515__$1;
(statearr_24553_24607[(2)] = null);

(statearr_24553_24607[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (5))){
var state_24515__$1 = state_24515;
var statearr_24554_24608 = state_24515__$1;
(statearr_24554_24608[(2)] = null);

(statearr_24554_24608[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (14))){
var state_24515__$1 = state_24515;
var statearr_24555_24609 = state_24515__$1;
(statearr_24555_24609[(2)] = true);

(statearr_24555_24609[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (26))){
var state_24515__$1 = state_24515;
var statearr_24556_24610 = state_24515__$1;
(statearr_24556_24610[(2)] = true);

(statearr_24556_24610[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (16))){
var inst_24469 = (state_24515[(2)]);
var state_24515__$1 = state_24515;
var statearr_24557_24611 = state_24515__$1;
(statearr_24557_24611[(2)] = inst_24469);

(statearr_24557_24611[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (30))){
var state_24515__$1 = state_24515;
var statearr_24558_24612 = state_24515__$1;
(statearr_24558_24612[(2)] = false);

(statearr_24558_24612[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (10))){
var inst_24445 = (state_24515[(7)]);
var inst_24452 = (state_24515[(2)]);
var inst_24454 = (inst_24445 == null);
var inst_24455 = cljs.core.not.call(null,inst_24454);
var state_24515__$1 = (function (){var statearr_24559 = state_24515;
(statearr_24559[(13)] = inst_24452);

return statearr_24559;
})();
if(inst_24455){
var statearr_24560_24613 = state_24515__$1;
(statearr_24560_24613[(1)] = (11));

} else {
var statearr_24561_24614 = state_24515__$1;
(statearr_24561_24614[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (18))){
var state_24515__$1 = state_24515;
var statearr_24562_24615 = state_24515__$1;
(statearr_24562_24615[(2)] = false);

(statearr_24562_24615[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24516 === (8))){
var inst_24446 = (state_24515[(9)]);
var inst_24449 = cljs.core.swap_BANG_.call(null,petrol.core._BANG_channels,cljs.core.disj,inst_24446);
var state_24515__$1 = state_24515;
var statearr_24563_24616 = state_24515__$1;
(statearr_24563_24616[(2)] = inst_24449);

(statearr_24563_24616[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__19002__auto__,ui_channel))
;
return ((function (switch__18890__auto__,c__19002__auto__,ui_channel){
return (function() {
var petrol$core$state_machine__18891__auto__ = null;
var petrol$core$state_machine__18891__auto____0 = (function (){
var statearr_24567 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24567[(0)] = petrol$core$state_machine__18891__auto__);

(statearr_24567[(1)] = (1));

return statearr_24567;
});
var petrol$core$state_machine__18891__auto____1 = (function (state_24515){
while(true){
var ret_value__18892__auto__ = (function (){try{while(true){
var result__18893__auto__ = switch__18890__auto__.call(null,state_24515);
if(cljs.core.keyword_identical_QMARK_.call(null,result__18893__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__18893__auto__;
}
break;
}
}catch (e24568){if((e24568 instanceof Object)){
var ex__18894__auto__ = e24568;
var statearr_24569_24617 = state_24515;
(statearr_24569_24617[(5)] = ex__18894__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_24515);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e24568;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__18892__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24618 = state_24515;
state_24515 = G__24618;
continue;
} else {
return ret_value__18892__auto__;
}
break;
}
});
petrol$core$state_machine__18891__auto__ = function(state_24515){
switch(arguments.length){
case 0:
return petrol$core$state_machine__18891__auto____0.call(this);
case 1:
return petrol$core$state_machine__18891__auto____1.call(this,state_24515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
petrol$core$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$0 = petrol$core$state_machine__18891__auto____0;
petrol$core$state_machine__18891__auto__.cljs$core$IFn$_invoke$arity$1 = petrol$core$state_machine__18891__auto____1;
return petrol$core$state_machine__18891__auto__;
})()
;})(switch__18890__auto__,c__19002__auto__,ui_channel))
})();
var state__19004__auto__ = (function (){var statearr_24570 = f__19003__auto__.call(null);
(statearr_24570[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__19002__auto__);

return statearr_24570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__19004__auto__);
});})(c__19002__auto__,ui_channel))
);

return c__19002__auto__;
});

petrol.core.start_message_loop_BANG_.cljs$lang$maxFixedArity = 3;

//# sourceMappingURL=core.js.map