(ns syksy.web.cors
  (:require [sieppari.context :as sc])
  (:import (java.util.concurrent TimeUnit)))


(def preflight-response {:status  204
                         :headers {"access-control-allow-methods"     "GET, POST, PUT, PATCH, DELETE"
                                   "access-control-allow-credentials" "true"
                                   "access-control-max-age"           (->> (.toSeconds TimeUnit/DAYS 30) (str))
                                   "cache-control"                    (->> (.toSeconds TimeUnit/DAYS 30) (str "max-age="))}})


(defn make-preflight-response [ctx]
  (let [headers (-> ctx :request :headers)]
    (update preflight-response :headers
            assoc "access-control-allow-origin" (get headers "origin" "*")
                  "access-control-allow-headers" (get headers "access-control-request-headers" "*"))))


(defn cors-interceptor []
  {:name    :cors-interceptor
   :compile (fn [{:keys [command]} _]
              (when command
                {:enter (fn [ctx]
                          (if (-> ctx :request :request-method (= :options))
                            (sc/terminate ctx (make-preflight-response ctx))
                            ctx))}))})
